﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Category
{
    public partial class Categories : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductCategoryList(string.Empty);
            }
        }

        private void BindProductCategoryList(string searchWord)
        {
            List<ProductCategory> pcList = ProductCategoryBL.GetList(Guid.Empty, searchWord);
            pcList = (from pb in pcList
                      where pb.IsActive == true
                      orderby pb.CategoryName ascending
                      select pb).ToList<ProductCategory>();
            grdProductCategory.DataSource = pcList;//.OrderBy(reg => reg.SequenceNo);
            grdProductCategory.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product Category found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductCategoryList(string.Empty);
            Master.ExportToExcel<Entities.ProductCategory>(grdProductCategory, "CategoryReport");
        }

        protected void grdProductCategory_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProductCategory.PageIndex = e.NewPageIndex;
            BindProductCategoryList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductCategoryList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductCategoryList(string.Empty);
        }
    }
}